unit IWCompButton32;

interface

uses
  {$IFDEF VSNET}System.ComponentModel, IWNETBaseControl, System.Drawing,{$ENDIF}
  Classes,
  IWBaseHTMLControl, IWControl32, IWHTMLTag, IWRenderContext, IWBaseInterfaces;

type
  TIWCustomButton32 = class(TIWCustomControl32, IIWSubmitControl)
  protected
    FSubmitParam : String;  
    FButtonType: TIWButtonType;

    procedure Submit(const AValue: string); override;

    procedure InitControl; override;
    {$IFDEF VSNET}
    function getText: string; reintroduce;virtual;
    procedure setText(AValue: string); reintroduce;virtual;
    {$ENDIF}
  public
    function GetSubmitParam : String;
    function RenderHTML(AContext: TIWBaseHTMLComponentContext): TIWHTMLTag; override;

    {$IFDEF VSNET}
    property Text: string read getText write setText;
    {$ENDIF}
    property ButtonType: TIWButtonType read FButtonType write FButtonType;
  end;

  {$IFDEF VSNET}
  {$R icons\Atozed.Intraweb.TIWButton32.bmp}
  TIWButton32 = class;
  [ToolboxItem(true), ToolboxBitmap(typeof(TIWButton32), 'TIWButton32.bmp')]
  {$ENDIF}
  TIWButton32 = class(TIWCustomButton32)
  published
    property ButtonType;
    {$IFDEF VSNET}
    property Text;
    {$ELSE}
    property Caption;
    {$ENDIF}
    property Enabled;
    property ExtraTagParams;
    property TabOrder;
    {$IFDEF CLR}
    property WebFont;
    {$ELSE}
    property Font;
    {$ENDIF}

    property OnClick;
  end;

implementation

uses
  SysUtils;

{ TIWCustomButton32 }

{$IFDEF VSNET}
function TIWCustomButton32.getText: string;
begin
  Result := Caption;
end;

procedure TIWCustomButton32.setText(AValue: string);
begin
  Caption := AValue;
  TIWNETBaseControl(Self).Invalidate;
end;
{$ENDIF}

procedure TIWCustomButton32.InitControl;
begin
  inherited;
  FNeedsFormTag := True;
  Height := 25;
  Width := 75;
end;

function TIWCustomButton32.GetSubmitParam: String;
begin
  Result := FSubmitParam;
end;

function TIWCustomButton32.RenderHTML(AContext: TIWBaseHTMLComponentContext): TIWHTMLTag;
begin
  Result := TIWHTMLTag.CreateTag('INPUT');
  try
    Result.AddStringParam('VALUE', TextToHTML(Caption));
    Result.AddStringParam('NAME', HTMLName);
    case ButtonType of
      btSubmit: Result.AddStringParam('TYPE', 'submit');
      btButton: Result.AddStringParam('TYPE', 'button');
      btReset: Result.AddStringParam('TYPE', 'reset');
    end;
  except
    FreeAndNil(Result);
    raise;
  end;
end;

procedure TIWCustomButton32.Submit(const AValue: string);
begin
  FSubmitParam := AValue;
  DoClick;
end;

end.
